/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import com.bdlington.Catalyst.VersionUtil;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_746;

public class ElytraSwap
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<PreferredItem> preferredItem;
    private final Setting<Integer> swapDelay;
    private int delayTimer;

    public ElytraSwap() {
        super(CatalystAddon.pvp, "ElytraSwap", "Swap elytra with chestplate.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.preferredItem = this.sgGeneral.add((Setting)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("preferred-item")).description("Which item to equip when neither elytra nor chestplate is worn.")).defaultValue((Object)PreferredItem.Elytra)).build());
        this.swapDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("swap-delay")).description("Delay in ticks before performing the swap (20 ticks = 1 second).")).defaultValue((Object)0)).min(0).max(100).sliderMin(0).sliderMax(40).build());
        this.delayTimer = 0;
    }

    public void onActivate() {
        this.delayTimer = (Integer)this.swapDelay.get();
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.delayTimer > 0) {
            --this.delayTimer;
            return;
        }
        this.performSwap();
        this.toggle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performSwap() {
        if (this.mc.field_1724 == null) return;
        if (this.mc.field_1761 == null) {
            return;
        }
        class_746 player = this.mc.field_1724;
        class_1799 chestSlot = VersionUtil.getArmorStack(player, 2);
        boolean hasElytra = chestSlot.method_7909() == class_1802.field_8833;
        boolean hasChestplate = this.isChestplate(chestSlot.method_7909());
        if (hasElytra) {
            class_1792 bestChestplate = this.findBestChestplate();
            if (bestChestplate != null) {
                this.swapWithInventoryItem(bestChestplate);
                return;
            }
            ChatUtils.error((String)"No chestplate found in inventory!", (Object[])new Object[0]);
            return;
        }
        if (hasChestplate) {
            if (this.findItemInInventory(class_1802.field_8833) != -1) {
                this.swapWithInventoryItem(class_1802.field_8833);
                return;
            }
            ChatUtils.error((String)"No elytra found in inventory!", (Object[])new Object[0]);
            return;
        }
        if (this.preferredItem.get() == PreferredItem.Elytra) {
            if (this.findItemInInventory(class_1802.field_8833) != -1) {
                this.equipFromInventory(class_1802.field_8833);
                return;
            }
            ChatUtils.error((String)"No elytra found in inventory!", (Object[])new Object[0]);
            return;
        }
        class_1792 bestChestplate = this.findBestChestplate();
        if (bestChestplate != null) {
            this.equipFromInventory(bestChestplate);
            return;
        }
        ChatUtils.error((String)"No chestplate found in inventory!", (Object[])new Object[0]);
    }

    private void swapWithInventoryItem(class_1792 item) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        int slot = this.findItemInInventory(item);
        if (slot != -1) {
            this.mc.field_1761.method_2906(0, slot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.mc.field_1761.method_2906(0, 6, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.mc.field_1761.method_2906(0, slot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
        }
    }

    private class_1792 findBestChestplate() {
        class_1792[] chestplates;
        for (class_1792 chestplate : chestplates = new class_1792[]{class_1802.field_22028, class_1802.field_8058, class_1802.field_8523, class_1802.field_8678, class_1802.field_8873, class_1802.field_8577}) {
            if (this.findItemInInventory(chestplate) == -1) continue;
            return chestplate;
        }
        return null;
    }

    private void equipFromInventory(class_1792 item) {
        if (this.mc.field_1724 == null || this.mc.field_1761 == null) {
            return;
        }
        int slot = this.findItemInInventory(item);
        if (slot != -1) {
            this.mc.field_1761.method_2906(0, slot, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
            this.mc.field_1761.method_2906(0, 6, 0, class_1713.field_7790, (class_1657)this.mc.field_1724);
        }
    }

    private int findItemInInventory(class_1792 item) {
        int i;
        if (this.mc.field_1724 == null) {
            return -1;
        }
        for (i = 0; i < 9; ++i) {
            if (this.mc.field_1724.method_31548().method_5438(i).method_7909() != item) continue;
            return i + 36;
        }
        for (i = 9; i < 36; ++i) {
            if (this.mc.field_1724.method_31548().method_5438(i).method_7909() != item) continue;
            return i;
        }
        return -1;
    }

    private boolean isChestplate(class_1792 item) {
        return item == class_1802.field_8577 || item == class_1802.field_8873 || item == class_1802.field_8523 || item == class_1802.field_8678 || item == class_1802.field_8058 || item == class_1802.field_22028;
    }

    public static enum PreferredItem {
        Elytra("Elytra"),
        Chestplate("Chestplate");

        private final String title;

        private PreferredItem(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

